/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Sphere;

public enum PortalCorner {
    LEFT_BOTTOM,
    LEFT_TOP,
    RIGHT_BOTTOM,
    RIGHT_TOP;

    private static final Logger LOGGER;

    public int getXSign() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LEFT_BOTTOM, LEFT_TOP -> -1;
            case RIGHT_BOTTOM, RIGHT_TOP -> 1;
        };
    }

    public int getYSign() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LEFT_BOTTOM, RIGHT_BOTTOM -> -1;
            case LEFT_TOP, RIGHT_TOP -> 1;
        };
    }

    public Vec3 getOffset(Portal portal) {
        return portal.axisW.m_82490_(portal.width / 2.0 * (double)this.getXSign()).m_82549_(portal.axisH.m_82490_(portal.height / 2.0 * (double)this.getYSign()));
    }

    public Vec3 getPos(Portal portal) {
        return portal.getOriginPos().m_82549_(this.getOffset(portal));
    }

    public Vec3 getOffset(UnilateralPortalState ups) {
        return ups.getAxisW().m_82490_(ups.width() / 2.0 * (double)this.getXSign()).m_82549_(ups.getAxisH().m_82490_(ups.height() / 2.0 * (double)this.getYSign()));
    }

    public Vec3 getPos(UnilateralPortalState ups) {
        return ups.position().m_82549_(this.getOffset(ups));
    }

    public static UnilateralPortalState performDragWithNoLockedCorner(UnilateralPortalState originalState, PortalCorner freeCorner, Vec3 freePos) {
        Vec3 offset = freeCorner.getOffset(originalState);
        Vec3 newPos = freePos.m_82546_(offset);
        return new UnilateralPortalState.Builder().from(originalState).position(newPos).build();
    }

    @Nullable
    public static UnilateralPortalState performDragWith1LockedCorner(UnilateralPortalState originalState, PortalCorner lockedCorner, Vec3 lockedPos, PortalCorner freeCorner, Vec3 freePos) {
        Vec3 originalFreeCornerPos = freeCorner.getPos(originalState);
        Vec3 originalOffset = originalFreeCornerPos.m_82546_(lockedPos);
        Vec3 newOffset = freePos.m_82546_(lockedPos);
        if (originalOffset.m_82556_() < 0.001 || newOffset.m_82556_() < 0.001) {
            return null;
        }
        double dot = originalOffset.m_82541_().m_82526_(newOffset.m_82541_());
        DQuaternion rotation = Math.abs(dot) > 0.99999 ? null : DQuaternion.getRotationBetween(originalOffset, newOffset);
        double scaling = newOffset.m_82553_() / originalOffset.m_82553_();
        Vec3 offset = originalState.position().m_82546_(lockedPos).m_82490_(scaling);
        if (rotation != null) {
            offset = rotation.rotate(offset);
        }
        Vec3 newOrigin = lockedPos.m_82549_(offset);
        DQuaternion newOrientation = rotation == null ? originalState.orientation() : rotation.hamiltonProduct(originalState.orientation());
        double newWidth = originalState.width() * scaling;
        double newHeight = originalState.height() * scaling;
        return new UnilateralPortalState.Builder().from(originalState).position(newOrigin).orientation(newOrientation).width(newWidth).height(newHeight).build();
    }

    public static DraggingConstraint getDraggingConstraintWith2LockedCorners(PortalCorner lockedCorner1, Vec3 lockedPos1, PortalCorner lockedCorner2, Vec3 lockedPos2, PortalCorner freeCorner) {
        int corner1XSign = lockedCorner1.getXSign();
        int corner1YSign = lockedCorner1.getYSign();
        int corner2XSign = lockedCorner2.getXSign();
        int corner2YSign = lockedCorner2.getYSign();
        int freeCornerXSign = freeCorner.getXSign();
        int freeCornerYSign = freeCorner.getYSign();
        if (corner1XSign == corner2XSign || corner1YSign == corner2YSign) {
            if (freeCornerXSign == corner1XSign || freeCornerYSign == corner1YSign) {
                Vec3 planeNormal = lockedPos2.m_82546_(lockedPos1);
                Plane plane = new Plane(lockedPos1, planeNormal);
                return new DraggingConstraint(plane, null);
            }
            Vec3 planeNormal = lockedPos1.m_82546_(lockedPos2);
            Plane plane = new Plane(lockedPos2, planeNormal);
            return new DraggingConstraint(plane, null);
        }
        Vec3 center = lockedPos1.m_82549_(lockedPos2).m_82490_(0.5);
        double radius = lockedPos1.m_82554_(lockedPos2) * 0.5;
        return new DraggingConstraint(null, new Sphere(center, radius));
    }

    @Nullable
    public static UnilateralPortalState performDragWith2LockedCorners(UnilateralPortalState originalState, PortalCorner lockedCorner1, Vec3 lockedPos1, PortalCorner lockedCorner2, Vec3 lockedPos2, PortalCorner freeCorner, Vec3 freePos) {
        DraggingConstraint constraint = PortalCorner.getDraggingConstraintWith2LockedCorners(lockedCorner1, lockedPos1, lockedCorner2, lockedPos2, freeCorner);
        Vec3 freePosLimited = constraint.constrain(freePos);
        if (freePosLimited == null) {
            return null;
        }
        Vec3[][] vertices = new Vec3[2][2];
        int corner1XSign = lockedCorner1.getXSign();
        int corner1YSign = lockedCorner1.getYSign();
        int corner2XSign = lockedCorner2.getXSign();
        int corner2YSign = lockedCorner2.getYSign();
        int freeCornerXSign = freeCorner.getXSign();
        int freeCornerYSign = freeCorner.getYSign();
        vertices[corner1XSign == -1 ? 0 : 1][corner1YSign == -1 ? 0 : 1] = lockedPos1;
        vertices[corner2XSign == -1 ? 0 : 1][corner2YSign == -1 ? 0 : 1] = lockedPos2;
        vertices[freeCornerXSign == -1 ? 0 : 1][freeCornerYSign == -1 ? 0 : 1] = freePosLimited;
        for (int cx = 0; cx <= 1; ++cx) {
            for (int cy = 0; cy <= 1; ++cy) {
                if (vertices[cx][cy] != null) continue;
                Vec3 sideVertex1 = vertices[1 - cx][cy];
                Vec3 sideVertex2 = vertices[cx][1 - cy];
                Vec3 diagonalVertex = vertices[1 - cx][1 - cy];
                Vec3 v1 = sideVertex1.m_82546_(diagonalVertex);
                Vec3 v2 = sideVertex2.m_82546_(diagonalVertex);
                vertices[cx][cy] = diagonalVertex.m_82549_(v1).m_82549_(v2);
            }
        }
        Vec3 horizontalAxis = vertices[1][0].m_82546_(vertices[0][0]);
        Vec3 verticalAxis = vertices[0][1].m_82546_(vertices[0][0]);
        Vec3 axisW = horizontalAxis.m_82541_();
        Vec3 axisH = verticalAxis.m_82541_();
        Vec3 normal = axisW.m_82537_(axisH);
        if (Math.abs(axisW.m_82526_(axisH)) > 0.01) {
            LOGGER.error("The dragged portal vertices are ill-formed");
            return null;
        }
        DQuaternion orientation = DQuaternion.matrixToQuaternion(axisW, axisH, normal);
        return new UnilateralPortalState.Builder().dimension(originalState.dimension()).position(vertices[0][0].m_82549_(vertices[1][1]).m_82490_(0.5)).orientation(orientation).width(horizontalAxis.m_82553_()).height(verticalAxis.m_82553_()).build();
    }

    static {
        LOGGER = LogUtils.getLogger();
    }

    public record DraggingConstraint(@Nullable Plane plane, @Nullable Sphere sphere) {
        @Nullable
        public Vec3 constrain(Vec3 pos) {
            if (this.sphere != null) {
                if (this.plane != null) {
                    Circle circle = this.sphere.getIntersectionWithPlane(this.plane);
                    if (circle == null) {
                        return null;
                    }
                    return circle.projectToCircle(pos);
                }
                return this.sphere.projectToSphere(pos);
            }
            if (this.plane != null) {
                return this.plane.getProjection(pos);
            }
            return pos;
        }
    }
}

